/*
 * Decompiled with CFR 0.152.
 */
package com.plantuml.api.cheerpj.v1;

import com.plantuml.api.cheerpj.Base64OutputStream;
import com.plantuml.api.cheerpj.JsonResult;
import com.plantuml.api.cheerpj.Utils;
import com.plantuml.api.cheerpj.WasmLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.ErrorUml;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.preproc.Defines;

public class Png {
    public static Object convertToBlob(String mode, String text, String pathOut) {
        long start;
        WasmLog.start = start = System.currentTimeMillis();
        WasmLog.log("Starting processing");
        try {
            FileFormatOption format = new FileFormatOption(FileFormat.PNG);
            if ("dark".equalsIgnoreCase(mode)) {
                format = format.withColorMapper(ColorMapper.DARK_MODE);
            }
            text = Utils.cleanText(text);
            BlockUmlBuilder builder = new BlockUmlBuilder(Collections.emptyList(), StandardCharsets.UTF_8, Defines.createEmpty(), (Reader)new StringReader(text), null, "string");
            List<BlockUml> blocks = builder.getBlockUmls();
            if (blocks.size() == 0) {
                return JsonResult.noDataFound(start);
            }
            Diagram system = blocks.get(0).getDiagram();
            if (system instanceof PSystemError) {
                ErrorUml error = ((PSystemError)system).getFirstError();
                WasmLog.log("[" + error.getPosition() + "] " + error.getError());
                return JsonResult.fromError(start, (PSystemError)system);
            }
            WasmLog.log("...processing...");
            FileOutputStream fos = new FileOutputStream(new File(pathOut));
            WasmLog.log("...loading data...");
            ImageData imageData = system.exportDiagram(fos, 0, format);
            WasmLog.log("Done!");
            fos.close();
            return JsonResult.ok(start, imageData, system);
        }
        catch (Throwable t) {
            WasmLog.log("Fatal error " + t);
            return JsonResult.fromCrash(start, t);
        }
    }

    public static Object convertToBase64(String mode, String text) {
        long start;
        WasmLog.start = start = System.currentTimeMillis();
        WasmLog.log("Starting processing");
        try {
            FileFormatOption format = new FileFormatOption(FileFormat.PNG);
            if ("dark".equalsIgnoreCase(mode)) {
                format = format.withColorMapper(ColorMapper.DARK_MODE);
            }
            text = Utils.cleanText(text);
            BlockUmlBuilder builder = new BlockUmlBuilder(Collections.emptyList(), StandardCharsets.UTF_8, Defines.createEmpty(), (Reader)new StringReader(text), null, "string");
            List<BlockUml> blocks = builder.getBlockUmls();
            if (blocks.size() == 0) {
                return JsonResult.noDataFound(start);
            }
            Diagram system = blocks.get(0).getDiagram();
            if (system instanceof PSystemError) {
                ErrorUml error = ((PSystemError)system).getFirstError();
                WasmLog.log("[" + error.getPosition() + "] " + error.getError());
                return JsonResult.fromError(start, (PSystemError)system);
            }
            WasmLog.log("...processing...");
            Base64OutputStream os64 = new Base64OutputStream();
            WasmLog.log("...loading data...");
            ImageData imageData = system.exportDiagram(os64, 0, format);
            WasmLog.log("Done!");
            os64.close();
            String base64 = os64.toString();
            return base64;
        }
        catch (Throwable t) {
            WasmLog.log("Fatal error " + t);
            return JsonResult.fromCrash(start, t);
        }
    }
}

