# -*- coding: binary -*-

module Msf::Exploit::Remote::HTTP::Moodle::Base
  # Checks if the site is online and running moodle
  #
  # @return [Rex::Proto::Http::Response,nil] Returns the HTTP response if the site is online and running moodle, nil otherwise
  def moodle_and_online?
    unless datastore['MOODLECHECK']
      vprint_status 'Skipping Moodle check...'
      return true
    end

    moodle_detect_regexes = [
      /"moodle":{"name":"moodle",/i,
    ]

    res = send_request_cgi!({
      'method' => 'GET',
      'uri' => normalize_uri(target_uri.path)
    }, 20, 10) # a cache inconsistency may result in 7 redirects

    return res if res && res.code == 200 && res.body && moodle_detect_regexes.any? { |r| res.body =~ r }

    return nil
  rescue ::Rex::ConnectionRefused, ::Rex::HostUnreachable, ::Rex::ConnectionTimeout => e
    print_error("Error connecting to #{target_uri}: #{e}")
    return nil
  end
end
