/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.vcs.internal.services;

import java.net.URI;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.vcs.VersionControlSpec;
import org.gradle.vcs.git.GitVersionControlSpec;
import org.gradle.vcs.git.internal.DefaultGitVersionControlSpec;
import org.gradle.vcs.internal.DefaultVersionControlRepository;
import org.gradle.vcs.internal.VersionControlSpecFactory;

public class DefaultVersionControlSpecFactory
implements VersionControlSpecFactory {
    private final ObjectFactory objectFactory;
    private final NotationParser<String, ModuleIdentifier> notationParser;

    public DefaultVersionControlSpecFactory(ObjectFactory objectFactory, NotationParser<String, ModuleIdentifier> notationParser) {
        this.objectFactory = objectFactory;
        this.notationParser = notationParser;
    }

    @Override
    public <T extends VersionControlSpec> T create(Class<T> specType) {
        if (specType.isAssignableFrom(GitVersionControlSpec.class)) {
            return (T)((VersionControlSpec)specType.cast(this.objectFactory.newInstance(DefaultGitVersionControlSpec.class, new Object[0])));
        }
        throw new IllegalArgumentException(String.format("Do not know how to create an instance of %s.", specType.getName()));
    }

    @Override
    public <T extends VersionControlSpec> DefaultVersionControlRepository create(Class<T> specType, URI uri) {
        return (DefaultVersionControlRepository)this.objectFactory.newInstance(DefaultVersionControlRepository.class, new Object[]{uri, this.notationParser, this.create(specType)});
    }
}

