/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.lifecycle;

import org.picocontainer.ComponentAdapter;
import org.picocontainer.LifecycleStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeLifecycleStrategy
implements LifecycleStrategy {
    private final LifecycleStrategy[] alternateStrategies;

    public CompositeLifecycleStrategy(LifecycleStrategy ... alternateStrategies) {
        this.alternateStrategies = alternateStrategies;
    }

    @Override
    public void start(Object component) {
        for (LifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            lifecycleStrategy.start(component);
        }
    }

    @Override
    public void stop(Object component) {
        for (LifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            lifecycleStrategy.stop(component);
        }
    }

    @Override
    public void dispose(Object component) {
        for (LifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            lifecycleStrategy.dispose(component);
        }
    }

    @Override
    public boolean hasLifecycle(Class<?> type) {
        for (LifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            if (!lifecycleStrategy.hasLifecycle(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLazy(ComponentAdapter<?> adapter) {
        for (LifecycleStrategy lifecycleStrategy : this.alternateStrategies) {
            if (!lifecycleStrategy.isLazy(adapter)) continue;
            return true;
        }
        return false;
    }
}

