/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.internal.p2.ui.ElementQueryDescriptor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.QueryableArtifactRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.RepositoryLocationQuery;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.model.Updates;
import org.eclipse.equinox.internal.p2.ui.query.ArtifactKeyWrapper;
import org.eclipse.equinox.internal.p2.ui.query.ArtifactRepositoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.AvailableIUWrapper;
import org.eclipse.equinox.internal.p2.ui.query.CategoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.query.InstalledIUElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.MetadataRepositoryElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.ProfileElementWrapper;
import org.eclipse.equinox.internal.p2.ui.query.QueryableUpdates;
import org.eclipse.equinox.internal.p2.ui.query.RequiredIUsQuery;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionFactory;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class QueryProvider {
    private final ProvisioningUI ui;
    public static final int METADATA_REPOS = 1;
    public static final int ARTIFACT_REPOS = 2;
    public static final int PROFILES = 3;
    public static final int AVAILABLE_IUS = 4;
    public static final int AVAILABLE_UPDATES = 5;
    public static final int INSTALLED_IUS = 6;
    public static final int AVAILABLE_ARTIFACTS = 7;

    public QueryProvider(ProvisioningUI ui) {
        this.ui = ui;
    }

    private static Map<String, String> getEnvFromProfile(IProfile profile) {
        if (profile == null) {
            return null;
        }
        String environments = profile.getProperty("org.eclipse.equinox.p2.environments");
        if (environments == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        StringTokenizer tokenizer = new StringTokenizer(environments, ",");
        while (tokenizer.hasMoreElements()) {
            String entry = tokenizer.nextToken();
            int i = entry.indexOf(61);
            String key = entry.substring(0, i).trim();
            String value = entry.substring(i + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    private IQuery<IInstallableUnit> createEnvironmentFilterQuery(IUViewQueryContext context, IProfile profile, IQuery<IInstallableUnit> query) {
        if (!context.getFilterOnEnv()) {
            return query;
        }
        Map<String, String> environment = QueryProvider.getEnvFromProfile(profile);
        if (environment == null) {
            return query;
        }
        IInstallableUnit envIU = InstallableUnit.contextIU(environment);
        IQuery filterQuery = QueryUtil.createMatchQuery((String)"filter == null || $0 ~= filter", (Object[])new Object[]{envIU});
        return QueryUtil.createCompoundQuery(query, (IQuery)filterQuery, (boolean)true);
    }

    public ElementQueryDescriptor getQueryDescriptor(QueriedElement element) {
        Policy policy = this.ui.getPolicy();
        IQueryable<URI> queryable = element.getQueryable();
        int queryType = element.getQueryType();
        IUViewQueryContext context = element.getQueryContext();
        if (context == null) {
            context = ProvUI.getQueryContext(policy);
            context.setInstalledProfileId(this.ui.getProfileId());
        }
        switch (queryType) {
            case 2: {
                queryable = new QueryableArtifactRepositoryManager(this.ui, false).locationsQueriable();
                return new ElementQueryDescriptor(queryable, (IQuery<?>)new RepositoryLocationQuery(), (Collector<?>)new Collector(), new ArtifactRepositoryElementWrapper(null, (Object)element));
            }
            case 4: {
                boolean showLatest = context.getShowLatestVersionsOnly();
                boolean hideInstalled = context.getHideAlreadyInstalled();
                IProfile targetProfile = null;
                String profileId = context.getInstalledProfileId();
                if (profileId != null) {
                    targetProfile = ProvUI.getProfileRegistry(this.ui.getSession()).getProfile(profileId);
                }
                IQuery topLevelQuery = policy.getVisibleAvailableIUQuery();
                IQuery<IInstallableUnit> categoryQuery = QueryUtil.createIUCategoryQuery();
                topLevelQuery = this.createEnvironmentFilterQuery(context, targetProfile, topLevelQuery);
                categoryQuery = this.createEnvironmentFilterQuery(context, targetProfile, categoryQuery);
                if (element instanceof MetadataRepositories || element instanceof MetadataRepositoryElement) {
                    if (context.getViewType() == 3 || !context.getUseCategories()) {
                        AvailableIUWrapper wrapper = new AvailableIUWrapper(queryable, element, false, context.getShowAvailableChildren());
                        if (showLatest) {
                            topLevelQuery = QueryUtil.createLatestQuery(topLevelQuery);
                        }
                        if (targetProfile != null) {
                            wrapper.markInstalledIUs(targetProfile, hideInstalled);
                        }
                        return new ElementQueryDescriptor(queryable, topLevelQuery, new Collector(), wrapper);
                    }
                    return new ElementQueryDescriptor(queryable, categoryQuery, new Collector(), new CategoryElementWrapper(queryable, element));
                }
                if (element instanceof CategoryElement || element instanceof IIUElement && ((IIUElement)((Object)element)).shouldShowChildren()) {
                    IQuery memberOfCategoryQuery;
                    boolean drillDownTheChildren;
                    boolean bl = drillDownTheChildren = element instanceof CategoryElement ? context.getShowAvailableChildren() : true;
                    if (element instanceof CategoryElement) {
                        IExpression matchesRequirementsExpression = ExpressionUtil.parse((String)"$0.exists(r | this ~= r)");
                        memberOfCategoryQuery = QueryUtil.createMatchQuery((IExpression)matchesRequirementsExpression, (Object[])new Object[]{((CategoryElement)element).getRequirements()});
                    } else {
                        memberOfCategoryQuery = QueryUtil.createIUCategoryMemberQuery((IInstallableUnit)((IIUElement)((Object)element)).getIU());
                    }
                    memberOfCategoryQuery = this.createEnvironmentFilterQuery(context, targetProfile, (IQuery<IInstallableUnit>)memberOfCategoryQuery);
                    AvailableIUWrapper availableIUWrapper = new AvailableIUWrapper(queryable, element, true, drillDownTheChildren);
                    if (targetProfile != null) {
                        availableIUWrapper.markInstalledIUs(targetProfile, hideInstalled);
                    }
                    if (element instanceof CategoryElement) {
                        if (showLatest) {
                            memberOfCategoryQuery = QueryUtil.createLatestQuery((IQuery)memberOfCategoryQuery);
                        }
                        return new ElementQueryDescriptor(queryable, memberOfCategoryQuery, new Collector(), availableIUWrapper);
                    }
                    IQuery query = QueryUtil.createCompoundQuery((IQuery)topLevelQuery, (IQuery)new RequiredIUsQuery(((IIUElement)((Object)element)).getIU()), (boolean)true);
                    if (showLatest) {
                        query = QueryUtil.createLatestQuery((IQuery)query);
                    }
                    return new ElementQueryDescriptor(queryable, query, new Collector(), availableIUWrapper);
                }
                return null;
            }
            case 5: {
                IProfile profile;
                IInstallableUnit[] toUpdate = null;
                if (element instanceof Updates) {
                    profile = ProvUI.getProfileRegistry(this.ui.getSession()).getProfile(((Updates)element).getProfileId());
                    toUpdate = ((Updates)element).getIUs();
                } else {
                    profile = ProvUI.getAdapter(element, IProfile.class);
                }
                if (profile == null) {
                    return null;
                }
                if (toUpdate == null) {
                    IQueryResult queryResult = profile.query(policy.getVisibleInstalledIUQuery(), null);
                    toUpdate = (IInstallableUnit[])queryResult.toArray(IInstallableUnit.class);
                }
                QueryableUpdates updateQueryable = new QueryableUpdates(this.ui, toUpdate);
                return new ElementQueryDescriptor(updateQueryable, context.getShowLatestVersionsOnly() ? QueryUtil.createLatestIUQuery() : QueryUtil.createIUAnyQuery(), new Collector());
            }
            case 6: {
                if (element instanceof IIUElement && context.getShowInstallChildren()) {
                    Collection<IRequirement> reqs = ((IIUElement)((Object)element)).getRequirements();
                    if (reqs.size() == 0) {
                        return null;
                    }
                    IExpression[] requirementExpressions = new IExpression[reqs.size()];
                    int i = 0;
                    for (IRequirement req : reqs) {
                        requirementExpressions[i++] = req.getMatches();
                    }
                    IExpressionFactory factory = ExpressionUtil.getFactory();
                    IQuery meetsAnyRequirementQuery = QueryUtil.createMatchQuery((IExpression)factory.or(requirementExpressions), (Object[])new Object[0]);
                    IQuery<IInstallableUnit> visibleAsAvailableQuery = policy.getVisibleAvailableIUQuery();
                    IQuery createCompoundQuery = QueryUtil.createCompoundQuery(visibleAsAvailableQuery, (IQuery)meetsAnyRequirementQuery, (boolean)true);
                    return new ElementQueryDescriptor(queryable, createCompoundQuery, new Collector(), new InstalledIUElementWrapper(queryable, element));
                }
                IProfile profile = ProvUI.getAdapter(element, IProfile.class);
                if (profile == null) {
                    return null;
                }
                return new ElementQueryDescriptor((IQueryable<?>)profile, policy.getVisibleInstalledIUQuery(), (Collector<?>)new Collector(), new InstalledIUElementWrapper((IQueryable<?>)profile, element));
            }
            case 1: {
                if (element instanceof MetadataRepositories) {
                    if (queryable == null) {
                        queryable = new QueryableMetadataRepositoryManager(this.ui, ((MetadataRepositories)element).getIncludeDisabledRepositories()).locationsQueriable();
                        element.setQueryable(queryable);
                    }
                    return new ElementQueryDescriptor(element.getQueryable(), (IQuery<?>)new RepositoryLocationQuery(), (Collector<?>)new Collector(), new MetadataRepositoryElementWrapper(null, (Object)element));
                }
                return null;
            }
            case 3: {
                queryable = new IQueryable<URI>(this.ui);
                return new ElementQueryDescriptor(queryable, QueryUtil.createMatchQuery(IProfile.class, (IExpression)ExpressionUtil.TRUE_EXPRESSION, (Object[])new Object[0]), new Collector(), new ProfileElementWrapper(null, (Object)element));
            }
            case 7: {
                if (!(queryable instanceof IArtifactRepository)) {
                    return null;
                }
                return new ElementQueryDescriptor(queryable, (IQuery<?>)ArtifactKeyQuery.ALL_KEYS, (Collector<?>)new Collector(), new ArtifactKeyWrapper((IArtifactRepository)queryable, (Object)element));
            }
        }
        return null;
    }
}

